﻿Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()
$shwTopNDD=[int]$TestInputs[5]
#>

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$measures='Measures.First Feedback Rating Avg','Measures.Second Feedback Rating Avg','Measures.First Feedback Rating Count','Measures.Second Feedback Rating Count','Measures.First Feedback Rating Poor Count','Measures.Second Feedback Rating Poor Count','Measures.First Feedback Rating Poor Percentage','Measures.Second Feedback Rating Poor Percentage','Measures.First Feedback Token Audio Issue Count','Measures.Second Feedback Token Audio Issue Count','Measures.First Feedback Token Video Issue Count','Measures.Second Feedback Token Video Issue Count'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
$FeedBackSumryStms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled} | Sort-Object -Property 'End Time' -Descending
$FeedBackSumryOutput=@()
if($rptTimNUPN -ne 'none'){
    foreach($strms in $FeedBackSumryStms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        if($iswrite){
            $FeedBackSumryOutput+=$strms
        }
        $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
        if($rptTimNUPN -eq $chktimNam){
            $iswrite=$true
        }
    }
}
if(!$iswrite){
    foreach($strms in $FeedBackSumryStms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        $cmprTime=[DateTime][String]$strms.'End Time'
        $cmprTime=$cmprTime.ToUniversalTime()
        if($cmprTime -ne ''){
            if($dat1 -lt $cmprTime){
                $FeedBackSumryOutput+=$strms 
            }
        }
    }
}

#foreach($output in $FeedBackSumryOutput){
#    Write-Host $output.'End Time' $output.'First UPN' $output.'Second UPN'
#}

$lastObj=$FeedBackSumryStms |Select-Object -First 1
$rptEdTimNUPN='LastReporting EndTime and UPN#'+$lastObj.'End Time'+'~'+$lastObj.'First UPN'+'~'+$lastObj.'Second UPN'
Write-Host $rptEdTimNUPN

if($FeedBackSumryOutput){
    $FirstFeedbackRatingAvg=0
    $SecondFeedbackRatingAvg=0
    $FirstFeedbackRatingCount=0
    $SecondFeedbackRatingCount=0
    $FirstFeedbackRatingPoorCount=0
    $SecondFeedbackRatingPoorCount=0
    $FirstFeedbackRatingPoorPercentage=0
    $SecondFeedbackRatingPoorPercentage=0
    $FirstFeedbackTokenAudioIssueCount=0
    $SecondFeedbackTokenAudioIssueCount=0
    $FirstFeedbackTokenVideoIssueCount=0
    $SecondFeedbackTokenVideoIssueCount=0

    if($FeedBackSumryOutput){
        Write-host '********************* FirstFeedbackRatingAvg measure***********************'
        $FirstFeedbackRatingAvglist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Avg')  -and $_.'First Feedback Rating Avg' -ne 'NaN' -and $_.'First Feedback Rating Avg' -gt 0.0001 } 
        $FirstFeedbackRatingAvg = ( $FirstFeedbackRatingAvglist | Measure-Object "First Feedback Rating Avg" -Average | select Average).Average
        if(-not $FirstFeedbackRatingAvg){  $FirstFeedbackRatingAvg=0 } else { $FirstFeedbackRatingAvg=$FirstFeedbackRatingAvg.ToString("#.##") }
        $FirstFeedbackRatingAvglist=$null

        Write-host '********************* SecondFeedbackRatingAvg measure***********************'
        $SecondFeedbackRatingAvglist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Avg')  -and $_.'Second Feedback Rating Avg' -ne 'NaN' -and $_.'Second Feedback Rating Avg' -gt 0.0001 } 
        $SecondFeedbackRatingAvg = ($SecondFeedbackRatingAvglist | Measure-Object "Second Feedback Rating Avg" -Average | select Average).Average
        if(-not $SecondFeedbackRatingAvg){  $SecondFeedbackRatingAvg=0 } else { $SecondFeedbackRatingAvg=$SecondFeedbackRatingAvg.ToString("#.##") }
        $SecondFeedbackRatingAvglist=$null

        Write-host '********************* FirstFeedbackRatingCount measure ***********************'
        $FirstFeedbackRatingCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Count')  -and $_.'First Feedback Rating Count' -ne 'NaN' } 
        $FirstFeedbackRatingCount = ($FirstFeedbackRatingCountlist | Measure-Object "First Feedback Rating Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackRatingCount){  $FirstFeedbackRatingCount=0 } else { $FirstFeedbackRatingCount=$FirstFeedbackRatingCount.ToString("#.##") }
        $FirstFeedbackRatingCountlist=$null

        Write-host '********************* SecondFeedbackRatingCount measure ***********************'
        $SecondFeedbackRatingCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Count')  -and $_.'Second Feedback Rating Count' -ne 'NaN' } 
        $SecondFeedbackRatingCount = ($SecondFeedbackRatingCountlist | Measure-Object "Second Feedback Rating Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackRatingCount){  $SecondFeedbackRatingCount=0 } else { $SecondFeedbackRatingCount=$SecondFeedbackRatingCount.ToString("#.##") }
        $SecondFeedbackRatingCountlist=$null

        Write-host '********************* dd FirstFeedbackRatingPoorCount measure***********************'
        $FirstFeedbackRatingPoorCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Poor Count')  -and $_.'First Feedback Rating Poor Count' -ne 'NaN' } 
        $FirstFeedbackRatingPoorCount = ($FirstFeedbackRatingPoorCountlist | Measure-Object "First Feedback Rating Poor Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackRatingPoorCount){  $FirstFeedbackRatingPoorCount=0 }  else { $FirstFeedbackRatingPoorCount=$FirstFeedbackRatingPoorCount.ToString("#.##") }
        if($FirstFeedbackRatingPoorCount){
            $ddlist = $FirstFeedbackRatingPoorCountlist | Where-Object { $_."First Feedback Rating Poor Count" -gt 0.0001 } | Sort-Object { $_."First Feedback Rating Poor Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddFirstFeedbackRatingPoorCount#' $strtTim ~!~ $endTim ~!~ $in.'First Feedback Rating Poor Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $FirstFeedbackRatingPoorCountlist=$null

        Write-host '********************* dd SecondFeedbackRatingPoorCount measure***********************'
        $SecondFeedbackRatingPoorCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Poor Count')  -and $_.'Second Feedback Rating Poor Count' -ne 'NaN' } 
        $SecondFeedbackRatingPoorCount = ($SecondFeedbackRatingPoorCountlist | Measure-Object "Second Feedback Rating Poor Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackRatingPoorCount){  $SecondFeedbackRatingPoorCount=0 } else { $SecondFeedbackRatingPoorCount=$SecondFeedbackRatingPoorCount.ToString("#.##") }
        if($SecondFeedbackRatingPoorCount){
            $ddlist = $SecondFeedbackRatingPoorCountlist | Where-Object { $_."Second Feedback Rating Poor Count" -gt 0.0001 } | Sort-Object { $_."Second Feedback Rating Poor Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddSecondFeedbackRatingPoorCount#' $strtTim ~!~ $endTim ~!~ $in.'Second Feedback Rating Poor Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $SecondFeedbackRatingPoorCountlist=$null

        Write-host '*********************  FirstFeedbackRatingPoorPercentage measure***********************'
        $FirstFeedbackRatingPoorPercentagelist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Poor Percentage')  -and $_.'First Feedback Rating Poor Percentage' -ne 'NaN' -and $_.'First Feedback Rating Poor Percentage' -gt 0.0001 } 
        $FirstFeedbackRatingPoorPercentage = ($FirstFeedbackRatingPoorPercentagelist | Measure-Object "First Feedback Rating Poor Percentage" -Average | select Average).Average
        if(-not $FirstFeedbackRatingPoorPercentage){  $FirstFeedbackRatingPoorPercentage=0 } else { $FirstFeedbackRatingPoorPercentage=$FirstFeedbackRatingPoorPercentage.ToString("#.##") }
        $FirstFeedbackRatingPoorPercentagelist=$null

        Write-host '*********************  SecondFeedbackRatingPoorPercentage measure***********************'
        $SecondFeedbackRatingPoorPercentagelist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Poor Percentage')  -and $_.'Second Feedback Rating Poor Percentage' -ne 'NaN' -and $_.'Second Feedback Rating Poor Percentage' -gt 0.0001 } 
        $SecondFeedbackRatingPoorPercentage = ($SecondFeedbackRatingPoorPercentagelist  | Measure-Object "Second Feedback Rating Poor Percentage" -Average | select Average).Average
        if(-not $SecondFeedbackRatingPoorPercentage){  $SecondFeedbackRatingPoorPercentage=0 } else { $SecondFeedbackRatingPoorPercentage=$SecondFeedbackRatingPoorPercentage.ToString("#.##") }
        $SecondFeedbackRatingPoorPercentagelist=$null

        Write-host '********************* dd FirstFeedbackTokenAudioIssueCount measure***********************'
        $FirstFeedbackTokenAudioIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Token Audio Issue Count')  -and $_.'First Feedback Token Audio Issue Count' -ne 'NaN' } 
        $FirstFeedbackTokenAudioIssueCount = ($FirstFeedbackTokenAudioIssueCountlist  | Measure-Object "First Feedback Token Audio Issue Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackTokenAudioIssueCount){  $FirstFeedbackTokenAudioIssueCount=0 } else { $FirstFeedbackTokenAudioIssueCount=$FirstFeedbackTokenAudioIssueCount.ToString("#.##") }
        if($FirstFeedbackTokenAudioIssueCount){
            $ddlist = $FirstFeedbackTokenAudioIssueCountlist | Where-Object { $_."First Feedback Token Audio Issue Count" -gt 0.0001 } | Sort-Object { $_."First Feedback Token Audio Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddFirstFeedbackTokenAudioIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'First Feedback Token Audio Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $FirstFeedbackTokenAudioIssueCountlist=$null

        Write-host '********************* dd SecondFeedbackTokenAudioIssueCount measure***********************'
        $SecondFeedbackTokenAudioIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Token Audio Issue Count')  -and $_.'Second Feedback Token Audio Issue Count' -ne 'NaN' } 
        $SecondFeedbackTokenAudioIssueCount = ($SecondFeedbackTokenAudioIssueCountlist  | Measure-Object "Second Feedback Token Audio Issue Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackTokenAudioIssueCount){  $SecondFeedbackTokenAudioIssueCount=0 }  else { $SecondFeedbackTokenAudioIssueCount=$SecondFeedbackTokenAudioIssueCount.ToString("#.##") }
        if($SecondFeedbackTokenAudioIssueCount){
            $ddlist = $SecondFeedbackTokenAudioIssueCountlist | Where-Object { $_."Second Feedback Token Audio Issue Count" -gt 0.0001 } | Sort-Object { $_."Second Feedback Token Audio Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddSecondFeedbackTokenAudioIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'Second Feedback Token Audio Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $SecondFeedbackTokenAudioIssueCountlist=$null
    
        Write-host '********************* dd FirstFeedbackTokenVideoIssueCount measure***********************'
        $FirstFeedbackTokenVideoIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Token Video Issue Count')  -and $_.'First Feedback Token Video Issue Count' -ne 'NaN' } 
        $FirstFeedbackTokenVideoIssueCount = ($FirstFeedbackTokenVideoIssueCountlist  | Measure-Object "First Feedback Token Video Issue Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackTokenVideoIssueCount){  $FirstFeedbackTokenVideoIssueCount=0 }  else { $FirstFeedbackTokenVideoIssueCount=$FirstFeedbackTokenVideoIssueCount.ToString("#.##") }
        if($FirstFeedbackTokenVideoIssueCount){
            $ddlist = $FirstFeedbackTokenVideoIssueCountlist | Where-Object { $_."First Feedback Token Video Issue Count" -gt 0.0001 } | Sort-Object { $_."First Feedback Token Video Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddFirstFeedbackTokenVideoIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'First Feedback Token Video Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $FirstFeedbackTokenVideoIssueCountlist=$null

        Write-host '********************* dd SecondFeedbackTokenVideoIssueCount measure***********************'
        $SecondFeedbackTokenVideoIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Token Video Issue Count')  -and $_.'Second Feedback Token Video Issue Count' -ne 'NaN' } 
        $SecondFeedbackTokenVideoIssueCount = ($SecondFeedbackTokenVideoIssueCountlist  | Measure-Object "Second Feedback Token Video Issue Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackTokenVideoIssueCount){  $SecondFeedbackTokenVideoIssueCount=0 } else { $SecondFeedbackTokenVideoIssueCount=$SecondFeedbackTokenVideoIssueCount.ToString("#.##") }
        if($SecondFeedbackTokenVideoIssueCount){
            $ddlist = $SecondFeedbackTokenVideoIssueCountlist | Where-Object { $_."Second Feedback Token Video Issue Count" -gt 0.0001 } | Sort-Object { $_."Second Feedback Token Video Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddSecondFeedbackTokenVideoIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'Second Feedback Token Video Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $SecondFeedbackTokenVideoIssueCountlist=$null
        Write-Host 'measures##' $FirstFeedbackRatingAvg ~ $SecondFeedbackRatingAvg ~ $FirstFeedbackRatingCount ~ $SecondFeedbackRatingCount ~ $FirstFeedbackRatingPoorCount ~ $SecondFeedbackRatingPoorCount ~ $FirstFeedbackRatingPoorPercentage ~ $SecondFeedbackRatingPoorPercentage ~ $FirstFeedbackTokenAudioIssueCount ~ $SecondFeedbackTokenAudioIssueCount ~ $FirstFeedbackTokenVideoIssueCount ~ $SecondFeedbackTokenVideoIssueCount
    }
}
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUskd21mKQLzeK6/CKykBhxaR1
# sPGggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUD+AxJgz/JsIl5ZcOwMrmReBq
# vQUwDQYJKoZIhvcNAQEBBQAEggEAkRED8wiQo6uGyz5s6WrkLxyQ7meYUAyPo1Nd
# Zhc3kLcY3B1MkNB3dc8uIoy1uXfzyChIti7HqOEIZbXTZpAd3bGJbdXGOJrbNssl
# RjT7Jx6dOYxwCh5uy7seDU62DoKuYuopUkXTNAG7TS+nH9HiPwx2Wt/I5UeqqlNu
# vaLfNa8ODHN1jVilBqc3bdzrzCLn3G26jrUA6nakAagAIAfZjcTNn3KIspXIu1Sw
# +X8L3LGAk5qb186Apumt/AAiIwLMI1Rq4gwfwDywMLcOuSwzwH1yMjL9daH2lIks
# fCKG0bCzDmRLBmBVYscrtAsLt+9lIH70G8b/IeCLlOy6psaKYaGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAxMjIxMTEyMjQzWjAjBgkqhkiG9w0BCQQxFgQU9LaCe2M383D28/+l4/ea
# +tVDFyEwDQYJKoZIhvcNAQEBBQAEggEAXNHWg+Tg5JER/fwazESQO4/AdHQ+6vOY
# wOfvz+U67VGtE1hYAZgHqZwkyqFsWYks29ADERa31ECVrfCRipbFYrK1k+/A9Fpx
# oVR0IHcN6iG/PoDXNAjzBvjX71vSA7RMrpTfcYM3bQ9NvmHHREodhOJpIGy0ppNj
# dQUD0gajulZhPPBZU4c8cpM8hBsHp9lXPwdtU5F3cYsUNPUOvHBqtnz1GrWcJUC5
# sEsIDqEvg+Mb5ZTrFXvQEfOTaQjix4uCTGXP3Smq07hwZqCZmc3BmbBXclC0d3x/
# ZH2FHLhYXBLX5dKRTPSLzrJmWW8mxQgfIZ3lyYYihERjltQDx8ywwQ==
# SIG # End signature block
