﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Users Mails and Mailboxes Details
    Created           :       15/09/2020    
    /*****************************************************************************
#>

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$strgLimit=$TestInputs[5]
$toreadDate_UsrsMailbx=[datetime]$TestInputs[6]
$toreadDate_UsrsMailactvty=[datetime]$TestInputs[7]
$toreadDate_UsrsMailAppUsg=[datetime]$TestInputs[8]
$rptNam=$TestInputs[9]
#>

$rptPath=$egurkhaPath+'\agent\EXO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){$appId=$input.ToString().Substring($input.IndexOf('~')+1)}        
        if($input.Contains("client_secret")){$appSecret=$input.ToString().Substring($input.IndexOf('~')+1)}        
        if($input.Contains("TenantName")){$tenantID=$input.ToString().Substring($input.IndexOf('~')+1)}        
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$MailboxUsageDetailCSV=$rptPath+'\MailboxUsageDetail'+$timenow+'.csv'
$url1 = "https://graph.microsoft.com/v1.0/reports/getMailboxUsageDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url1 -filePath $MailboxUsageDetailCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalMailboxUsageDetail=Import-Csv $MailboxUsageDetailCSV
    $url1=$TotalMailboxUsageDetail.'@odata.nextLink'
    if($url1 -eq $null -or $url1 -eq ''){
        break
    }
}
$firstRecord1=$TotalMailboxUsageDetail | select ReportRefreshDate -First 1
$ReportRefreshDate1=($firstRecord1.ReportRefreshDate)
$diffence1=(NEW-TIMESPAN –Start $toreadDate_UsrsMailbx –End $ReportRefreshDate1 | Select-Object Days).Days
if($diffence1 -ge 1){$reportRefreshed1=$true}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$UserEmailActivitiesCSV=$rptPath+'\UserEmailActivities'+$timenow+'.csv'
$url2 = "https://graph.microsoft.com/v1.0/reports/getEmailActivityUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url2 -filePath $UserEmailActivitiesCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $UserEmailActivities=Import-Csv $UserEmailActivitiesCSV
    $url2=$UserEmailActivities.'@odata.nextLink'
    if($url2 -eq $null -or $url2 -eq ''){
        break
    }
}
$firstRecord2=$UserEmailActivities | select ReportRefreshDate -First 1
$ReportRefreshDate2=($firstRecord2.ReportRefreshDate)
$diffence2=(NEW-TIMESPAN –Start $toreadDate_UsrsMailactvty –End $ReportRefreshDate2 | Select-Object Days).Days
if($diffence2 -ge 1){$reportRefreshed2=$true}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$MailAppUsageCSV=$rptPath+'\MailAppUsage'+$timenow+'.csv'
$url3 = "https://graph.microsoft.com/v1.0/reports/getEmailAppUsageUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url3 -filePath $MailAppUsageCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalMailAppUsage=Import-Csv $MailAppUsageCSV
    $url3=$TotalMailAppUsage.'@odata.nextLink'
    if($url3 -eq $null -or $url3 -eq ''){
        break
    }
}
$firstRecord3=$TotalMailAppUsage | select ReportRefreshDate -First 1
$ReportRefreshDate3=($firstRecord3.ReportRefreshDate)
$diffence3=(NEW-TIMESPAN –Start $toreadDate_UsrsMailAppUsg –End $ReportRefreshDate3 | Select-Object Days).Days
if($diffence3 -ge 1){$reportRefreshed3=$true}

if($reportRefreshed1 -and $reportRefreshed2 -and $reportRefreshed3){
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailbx –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailbx=$toreadDate_UsrsMailbx.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailbx
        $notFirsttime = $true
        $TotalMailboxUsage =$TotalMailboxUsageDetail | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalMailboxUsage)
        {
            Write-Host 'ReadDate of UsersMailbox Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailbox Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }

    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailactvty –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailactvty=$toreadDate_UsrsMailactvty.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailactvty
        $notFirsttime = $true
        $UserEmailAct =$UserEmailActivities | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($UserEmailAct)
        {
            Write-Host 'ReadDate of UsersMailActivity Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailActivity Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }

    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailAppUsg –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailAppUsg=$toreadDate_UsrsMailAppUsg.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailAppUsg
        $notFirsttime = $true
        $TotalMailAppUsg =$TotalMailAppUsage | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalMailAppUsg)
        {
            Write-Host 'ReadDate of UsersMailAppUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailAppUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
}
foreach($User in $TotalMailboxUsage){
    $ItemCount=$User.ItemCount      
    $IssueWarningQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.IssueWarningQuota/1073741824),2)))*100
    if($IssueWarningQuotaLimit -ge $strgLimit){ $ReachingIssueWarningQuotaLimit=1 }else{ $ReachingIssueWarningQuotaLimit=0 }   
    $ProhibitSendQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.ProhibitSendQuota/1073741824),2)))*100
    if($ProhibitSendQuotaLimit -ge $strgLimit){ $ReachingProhibitSendQuotaLimit=1 }else{ $ReachingProhibitSendQuotaLimit=0 }     
    $ProhibitSendRecvQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.'ProhibitSend/ReceiveQuota'/1073741824),2)))*100
    if($ProhibitSendRecvQuotaLimit -ge $strgLimit){ $ReachingProhibitSendRecvQuotaLimit=1 }else{ $ReachingProhibitSendRecvQuotaLimit=0 }
    $DeletedItemCount=$User.DeletedItemCount    
    $UserID=$User.UserPrincipalName
    $Output='info&Measures='+$UserID+'~'+$ItemCount+'~'+[math]::Round(($User.StorageUsed/1073741824),2)+'~'+[math]::Round(($User.IssueWarningQuota/1073741824),2)+'~'+[math]::Round(($User.ProhibitSendQuota/1073741824),2)+'~'+[math]::Round(($User.'ProhibitSend/ReceiveQuota'/1073741824),2)+'~'+$ReachingIssueWarningQuotaLimit+'~'+$ReachingProhibitSendQuotaLimit+'~'+$ReachingProhibitSendRecvQuotaLimit+'~'+$DeletedItemCount+'~'+[math]::Round(($User.DeletedItemSize/1073741824),2)
    Write-Host $Output 
}
Remove-Item $MailboxUsageDetailCSV

foreach($User in $UserEmailAct){
        $AssignedProducts = New-Object -TypeName "System.Collections.ArrayList"
        $UserPrincipalName=$User.UserPrincipalName
        $SendCount=$User.SendCount
        $ReceiveCount=$User.ReceiveCount
        $ReadCount=$User.ReadCount        
        $Output = 'info&Measures='+$UserPrincipalName+'~'+$SendCount+'~'+$ReceiveCount+'~'+$ReadCount
        Write-Host $Output        
}
Remove-Item $UserEmailActivitiesCSV

foreach($Apps in $TotalMailAppUsg){
    #----------------MailForMac ---------------------
    if($Apps.MailForMac -eq ""){$MailForMac = "0"}elseif($Apps.MailForMac -eq "Undetermined"){$MailForMac = "1"}else{$MailForMac="2"}
    #---------------OutlookForMac---------------------
    if($Apps.OutlookForMac -eq ""){$OutlookForMac = "0"}elseif($Apps.OutlookForMac -eq "Undetermined"){$OutlookForMac = "1"}else{$OutlookForMac="2"}             
    #---------------OutlookForWindows---------------------
    if($Apps.OutlookForWindows -eq ""){$OutlookForWindows = "0"}elseif($Apps.OutlookForWindows -eq "Undetermined"){$OutlookForWindows = "1"}else{$OutlookForWindows="2"}        
    #---------------OutlookForMobile---------------------
    if($Apps.OutlookForMobile -eq ""){$OutlookForMobile = "0"}elseif($Apps.OutlookForMobile -eq "Undetermined"){$OutlookForMobile = "1"}else{$OutlookForMobile="2"}
    #---------------OtherForMobile---------------------
    if($Apps.OtherForMobile -eq ""){$OtherForMobile = "0"}elseif($Apps.OtherForMobile -eq "Undetermined"){$OtherForMobile = "1"}else{$OtherForMobile="2"}        
    #---------------OutlookForWeb---------------------
    if($Apps.OutlookForWeb -eq ""){$OutlookForWeb = "0"}elseif($Apps.OutlookForWeb -eq "Undetermined"){$OutlookForWeb = "1"}else{$OutlookForWeb="2"}
    #---------------POP3App---------------------
    if($Apps.POP3App -eq ""){$POP3App = "0"}elseif($Apps.POP3App -eq "Undetermined"){$POP3App = "1"}else{$POP3App="2"}
    #---------------IMAP4App---------------------
    if($Apps.IMAP4App -eq ""){$IMAP4App = "0"}elseif($Apps.IMAP4App -eq "Undetermined"){$IMAP4App = "1"}else{$IMAP4App="2"}
    #---------------SMTPApp---------------------
    if($Apps.SMTPApp -eq ""){$SMTPApp = "0"}elseif($Apps.SMTPApp -eq "Undetermined"){$SMTPApp = "1"}else{$SMTPApp="2"}

$MailAppUsage='info&Measures='+$Apps.UserPrincipalName+'~'+$MailForMac+'~'+$OutlookForMac+'~'+$OutlookForWindows+'~'+$OutlookForMobile+'~'+$OtherForMobile+'~'+$OutlookForWeb+'~'+$POP3App+'~'+$IMAP4App+'~'+$SMTPApp
Write-Host $MailAppUsage
}
Remove-Item $MailAppUsageCSV
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUKv5R8x0tsf66rzX7zO/MRtMV
# 0A2ggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQU0OHY7jDhv0RUyF9zbTpTACcD
# vDwwDQYJKoZIhvcNAQEBBQAEggEAP8oti1Q+/nQqDm+jbpSmoSwdnU/9qoKAEePN
# vQ9Wq1oK4SSyDegYRA6gvV+DnhWpS7c3tvvJIzoiqzeKbZLMKUPY10fh2Dspodh/
# axTNRxlJq9hkqXwfZUQoDq5t4TWpy+qhI4ISeDBfyZ3v+swaeLUiHzzdHYLqsTbC
# zDedn1GRF93n2j5eAuXN+mmhP/bKzhbJ5tINRkLhJoiuxpxCBSdk55ReUJTm4TVh
# IBBodgl+nUjLKg8QVA99m/UrYvuUcSFChzVKuMt7f+vhzJEd/hC1unGC2rPTxJeM
# p3N4bMCUBvAAahmmqn8lDTklA8Bpucgbl7xiZLGTtvtpMFfcjaGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwOTIzMTExMjExWjAjBgkqhkiG9w0BCQQxFgQUNNo0jkWm+fVGaCaCKRRA
# zn1oApIwDQYJKoZIhvcNAQEBBQAEggEALUHQ5hlh9ft4O/m/oJPpF65yVLOJyzwx
# TlIzBb4s8tjjWsvkqW+LDjkGHc24UxBgfqzoLaciif0onFr0jiLErtrzkB1IQDPK
# y0IoG/mrvhG/9SJ5vQX3sRDXq5n51NX4dhJea0qDRsqUQzr1hyU8C9nhzmnhEaA5
# 7FHdquoE1Z29Lng3lzazbl5+zzWBfLYVCagHWKnxUfu2b4vxib1sRC6cJRlcV+t2
# F6pOs9+5o6X4czPA3QfEcoWAD46hXwL9OpN/+9FZuG7nqX8jLuQc0YTGlTx+h9a7
# X8HoRUBV9GzXQ3/fy1jcpQuDbA0LyxWIiI2o80kbcj+ruDX3YawCIQ==
# SIG # End signature block
