﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egDatnKy -WarningAction SilentlyContinue


clear
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyserverip=$TestInputs[2]
$proxyUsr=$TestInputs[3]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[4]
$temp=$TestInputs[5]
$unReceivTims=$TestInputs[6]
$rptNam=$TestInputs[7]
$smtpPort=$TestInputs[8]
$useSSL=$TestInputs[9]
#>

$tempArr=$temp.Split('#')
[int]$measurePeriod=$tempArr[0]
[int]$rtim=$tempArr[1]
$lastSendTims=[String]$tempArr[2]
$isAllow=$true

$subjectStr='O365MailDeliverabilityTest '+$rptNam+' -'
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim()}
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred=New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        $sessionOption=New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
    }
}
try{
    $credentials=New-Object System.Management.Automation.PSCredential($userName,(ConvertTo-SecureString $password -AsPlainText -Force))   
    $sessionOption=New-PSSessionOption -SkipRevocationCheck
    Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $credentials -PSSessionOption $sessionOption
}catch{
    Write-Error 'Exception Occured' $_.Exception.Message 
    Write-Host 'PSsession Exception Occured'
    $isAllow=$false
}

$paramInMin=(($measurePeriod/60)*5)
if($isAllow){
    if($lastSendTims -ne $null -and $lastSendTims -ne '' -and $lastSendTims -ne 'nil'){
        $lstTimsArr=$lastSendTims -split ('~')
        $srchStr=@()
        $notReceiveMail=''
        for($i=0;$i -lt $lstTimsArr.Length;$i++){
            $notReceiveMail+='~'+$subjectStr+$lstTimsArr[$i]
            $srchStr+=$subjectStr+$lstTimsArr[$i]
        }
        if($unReceivTims -ne 'nil'){
            $unReceivTimsArr= $unReceivTims -split ('~')
            foreach($a in $unReceivTimsArr){
                $srchStr+=$subjectStr+$a
            }
            $unReceivTims='~'+$unReceivTims
        }

        # ****RECEIVE MESSAGES*****
        $todayDatFmt=Get-Date -Format 'dd/MM/yyyy'
        $todayDat=[datetime]::ParseExact($todayDatFmt,'dd/MM/yyyy',$null).ToUniversalTime()
 
        $msgTrace=Get-MessageTrace -RecipientAddress $userName -StartDate $todayDat.AddMinutes(-($paramInMin)) -EndDate $todayDat.AddDays(1) | select * |Where-Object {$_.Subject -in $srchStr}
        
        $totRndTim=0
        $maxRndTripTim=0
        $j=0      
        foreach($msg in $msgTrace){
            $receivTim=[Datetime]$msg.Received
            $replcSub='~'+$msg.Subject
            $notReceiveMail=$notReceiveMail.Replace($replcSub,'')
            $sub=$msg.Subject.Split('-')
            $sendTim=[DateTime][long]$sub[1]
            $duration = $receivTim-$sendTim
            $millsec=((($duration.Minutes*60)+($duration.Seconds))*1000)
            $totmilliSec=$millsec+$duration.Milliseconds
            if($unReceivTims -ne 'nil'){
                $curSub='~'+$sub[1]
               if($unReceivTims.Contains($curSub)) {
                    $unReceivTims=$unReceivTims.Replace($curSub,'')
                    $delayedMsgs="DelayedReceiveMsgs #"+$sendTim+'~!~'+$receivTim+'~!~'+([Math]::Round((($totmilliSec/60)/1000), 2))
                    Write-Host $delayedMsgs
               }
               if($unReceivTims -eq '' -and $unReceivTims -eq $null){$unReceivTims='nil'}
            }
            $roundTripTim=(($totmilliSec)/1000)
            $totRndTim+=$roundTripTim
            if($roundTripTim -gt $maxRndTripTim){
                $maxRndTripTim=$roundTripTim
            }
            $j++             
        }

        if($j -ne 0){
            $avgRndTim=[math]::Round((($totRndTim/$j)/60),2)
            $maxRndTripTim=[math]::Round(($maxRndTripTim/60),2)
            $totRTSec=[math]::Round($totRndTim,2)
            $recvMeasure='Receive Mail ~100~'+$j+'~'+$totRTSec+'~'+$avgRndTim+'~'+$maxRndTripTim
            Write-Host $recvMeasure
        }else{
            $recvMeasure='Receive Mail ~0~-5~-5~-5~-5'
            Write-Host $recvMeasure
        }

        #***FOR DELAYED RECEIVING MESSAGES ****
        $notReceiveTims=''
        if($notReceiveMail -ne $null -and $notReceiveMail -ne ''){
            $notReceiveTims=$notReceiveMail.Substring(1,$notReceiveMail.Length)
            $notReceiveTims=$notReceiveTims.Replace($subjectStr,'')
        }
        if($unReceivTims -ne 'nil' -or $notReceiveTims -ne ''){   
            if($notReceiveTims -ne ''){
                $notReceiveTims='NotReceive Timings #'+$notReceiveTims+$unReceivTims
            }
            else{
                $notReceiveTims='NotReceive Timings #'+$unReceivTims.Substring(1)
            }
            Write-Host $notReceiveTims
        }    
    }

    # ****DELETE MESSAGES*****
    Try{
	$exSub=$subjectStr+'*'
	$delSub='''Subject:'+'"'+$exSub+'"'''
	$null=Search-Mailbox -Identity $userName -SearchQuery $delSub -DeleteContent -WarningAction SilentlyContinue -Force
    }Catch{
	$emsg='Search-Mailbox Err Msg #'+$_.Exception.Message
        Write-Host $emsg
    }

    # *****SEND MESSAGES******
    $smtp =$azureEnvArr[2]
    $b4Cnt=0
    $aftrCnt=0
    $totSendTim=0
    $sendTimStr=''
    for($q=0;$q -lt $rtim;$q++){
        $body="Testing Mail Deliverability<br>"
        $body+="Please do not respond to this email"

        $datFmt1=Get-Date -Format 'dd/MM/yyyy HH:mm:ss ffff'
        $datTim1=[datetime]::ParseExact($datFmt1,'dd/MM/yyyy HH:mm:ss ffff',$null).ToUniversalTime()
        $subject=$subjectStr+$datTim1.Ticks
        try{
            $b4Cnt++
            if($useSSL -eq 'true'){
                Send-MailMessage -From $userName -To $userName -Subject $subject -Body $body -BodyAsHtml -smtpserver $smtp -Port $smtpPort -Credential $credentials -UseSsl -ErrorAction Stop
            }
            else{
                Send-MailMessage -From $userName -To $userName -Subject $subject -Body $body -BodyAsHtml -smtpserver $smtp -Port $smtpPort -Credential $credentials -ErrorAction Stop
            }
            $aftrCnt++
            if($q -eq 0){
                $sendTimStr=$subject
            }else{
                $sendTimStr=$sendTimStr+'~'+$subject
            }  
        }catch{
            $emsg='Sending Failed Msg #'+$_.Exception.Message
            Write-Host $emsg
	    if($emsg.Contains('The SMTP server requires a secure connection or the client was not authenticated')){break;}
            continue
        } 
        $datFmt2=Get-Date -Format 'dd/MM/yyyy HH:mm:ss ffff'
        $datTim2=[datetime]::ParseExact($datFmt2,'dd/MM/yyyy HH:mm:ss ffff',$null).ToUniversalTime()

        $sendTimDur=$datTim2-$datTim1
        $sendMillsec=((($sendTimDur.Minutes*60)+($sendTimDur.Seconds))*1000)
        $stotmilliSec=$sendMillsec+$sendTimDur.Milliseconds
        $sendTim=($stotmilliSec)/1000
        $totSendTim+=$sendTim
    }
    if($b4Cnt -eq $aftrCnt){
        $msg='Send Mail ~'+'100~'+$aftrCnt+'~'+$totSendTim
        Write-Host $msg
    }elseif($aftrCnt -ne 0){
        $msg='Send Mail ~0'+'~'+$aftrCnt+'~'+$totSendTim
        Write-Host $msg
    }
    else{
        $msg='Send Mail ~0~-5~-5'
        Write-Host $msg
    }
    $sendTimStr=$sendTimStr.Replace($subjectStr,'')
    if($sendTimStr -eq $null -or $sendTimStr -eq ''){$sendTimStr='nil'}
    $sendTimStr='SendTimeStr#'+$sendTimStr
    Write-Host $sendTimStr
}

$getSession=Get-PSSession -ErrorAction SilentlyContinue
if($getSession -ne $null -and $getSession -ne ''){
    Disconnect-ExchangeOnline -Confirm:$false
}


# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUCwB2C5dANyyuMgI+WHEC7QTF
# zLKggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQU6/qJPslsErCzPvBVEjTzmv/N
# P6wwDQYJKoZIhvcNAQEBBQAEggEAWD14lI4ASuuLgEXzbqVIPADCLqBMiv+EnbEL
# OWphersjoeNABDNV+sohYBN1UlqdYyroa+RBH5Tm/tb58SbclRbYoD7aNraDPt+h
# dJ/W/e7GvuFHpwz/6Z3hhQTJsEfbBDghNq6HXl+To1rpUIcnCYL9JmR1ARyfAqS2
# WPztevoch83kasPVsIha7qQOA9JvaaYVIsics4ob0IN5UDPh1Gf/eR2XipCH9R8J
# tNpM15hwg8KHKoJU8Vey+bXxItXgf80G/+3x9hJOMNg+0gqclGFNxW2ySPhHFYzP
# xmQo6V5geG+gWLmB6OkdefoydB4BCqd6o6F+tUqoSksk50vUuqGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwOTE1MTIyNjIxWjAjBgkqhkiG9w0BCQQxFgQUYUnBls3VT8usqwSnupGD
# 5EduWskwDQYJKoZIhvcNAQEBBQAEggEAV9GUZxaZkZcmDMomkAiNfLi6jz6RTfR2
# 9KyyQ3/xsux48jffewOwTM21IrsKr8Qm3oNTR3dvlU1frWeSmlmY857L8sN5Wiiv
# 9rdLu0LMQgt+3Hi8mfRNBZhUzNyvr0qyjeBvKpIWNkUjs60IOjJuEZCg7NyDsWih
# xHRUJN9xOQ6fSVS8BCKAw8/AkfOqy6+SJCnBFiQbBxHjq/tL6Ay0bYbr9BvV5i0I
# GF3utQ6gm4XJXJQ3bkIszIfiej7gaQL2NsOl2GzCB7AQKwceY7SQcwr46hTOQ/yc
# 0EyAW425KjQUkRbfmAAB0H9MVLNsaHwlVwb0+e+1ZR4NGYonvUa3Eg==
# SIG # End signature block
